/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.ProviderException;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class SessionRef
extends PhantomReference<Session>
implements Comparable<SessionRef> {
    static ReferenceQueue<Session> refQueue = new ReferenceQueue();
    private static Set<SessionRef> refList = Collections.synchronizedSortedSet(new TreeSet());
    private long id;
    private Token token;

    SessionRef(Session session, long l, Token token) {
        super(session, refQueue);
        this.id = l;
        this.token = token;
        refList.add(this);
    }

    void dispose() {
        refList.remove(this);
        try {
            if (this.token.isPresent(this.id)) {
                this.token.p11.C_CloseSession(this.id);
            }
        }
        catch (ProviderException | PKCS11Exception exception) {
        }
        finally {
            this.clear();
        }
    }

    @Override
    public int compareTo(SessionRef sessionRef) {
        if (this.id == sessionRef.id) {
            return 0;
        }
        return this.id < sessionRef.id ? -1 : 1;
    }
}

