/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Utils;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortException;

public abstract class ComBiopod {
    public static SerialPort serialPort;
    public static int connexionBiopod;
    public static String portOuvert;
    public static boolean dataRecue;

    static boolean searchBiopod() {
        return Main.getConfig().versionRecherche && connexionBiopod == 0;
    }

    static void closeConnexion() {
        try {
            Utils.debugInfo("Close connexion Biopod");
            connexionBiopod = 0;
            portOuvert = null;
            Main.menu.changeBTStatus();
            if (serialPort.isOpened()) {
                serialPort.setDTR(false);
                serialPort.closePort();
            }
        }
        catch (SerialPortException ep) {
            Utils.debugInfo("USB d\u00e9branch\u00e9");
        }
        catch (Exception e) {
            Utils.debugInfo("closeConnexion : " + e);
        }
    }

    static void initConnexion() {
        try {
            Utils.debugInfo("Trying Biopod Port " + portOuvert);
            serialPort = new SerialPort(portOuvert);
            serialPort.openPort();
            Thread.sleep(300L);
            serialPort.setParams(256000, 8, 1, 2, false, true);
            serialPort.addEventListener(ComBiopod::rs232SerialEvent);
            ComBiopod.ping();
            connexionBiopod = 2;
            Utils.sleep(500L);
            double timeNoConnected = 0.0;
            while (connexionBiopod > 1) {
                if (dataRecue) {
                    dataRecue = false;
                    timeNoConnected = 0.0;
                } else {
                    timeNoConnected += 0.5;
                }
                if (timeNoConnected > 3.0) {
                    ComBiopod.closeConnexion();
                }
                Utils.sleep(500L);
            }
            Main.telecommandeStop();
            ComBiopod.closeConnexion();
        }
        catch (Exception e) {
            e.printStackTrace();
            ComBiopod.closeConnexion();
        }
    }

    static synchronized void ping() {
    }

    static synchronized void rs232SerialEvent(SerialPortEvent event) {
        try {
            if (event.isRXCHAR()) {
                byte[] bread = serialPort.readBytes();
                Utils.debugInfo("%d octets re\u00e7us du Biopod", bread.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        connexionBiopod = 0;
        portOuvert = null;
        dataRecue = false;
    }
}

