/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.configuration.CloudManager;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javax.swing.filechooser.FileSystemView;

public abstract class Security {
    public static final int KEY_READ = 131097;
    public static final int REG_SUCCESS = 0;
    private static final Preferences userRoot = Preferences.userRoot();
    public static final Class<? extends Preferences> userClass = userRoot.getClass();
    public static final Preferences systemRoot = Preferences.systemRoot();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;
    public static int verifCheckSum;

    public static void verifStart() {
        Security.verifCheckSum();
        if (Computer.isMac()) {
            Security.verifInstallMac();
        }
        if (Computer.isWindows()) {
            Security.verifLnk();
        }
    }

    private static void verifCheckSum() {
        try {
            String f = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (f.endsWith("/")) {
                Utils.debugInfo("!!! Pas de verif du checksum !!!");
                return;
            }
            if (f.charAt(0) == '/' && f.charAt(2) == ':') {
                f = f.substring(1);
            }
            String theorique = new String(Files.readAllBytes(Paths.get(Computer.absolutePath + "20250195.hash", new String[0])));
            long start = System.currentTimeMillis();
            String md5 = Security.getChecksum(f);
            Utils.debugInfo("md5 : %s (%d ms)", md5, System.currentTimeMillis() - start);
            if (theorique.equals(md5)) {
                verifCheckSum = 0;
            } else {
                verifCheckSum = 2;
                CloudManager.sendJdd("CheckSum Invalide", new Object[0]);
                Utils.popupAlert(TransientConfig.translate("checksum_invalide"));
                Platform.runLater(Main.menu::goToAutotest);
            }
        }
        catch (Exception e) {
            Utils.debugInfo("Impossible de v\u00e9rifier le checksum : %s", e);
        }
    }

    private static String getChecksum(String filename) throws Exception {
        int numRead;
        MessageDigest complete = MessageDigest.getInstance("MD5");
        InputStream fis = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        byte[] buffer = new byte[1024];
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        byte[] b = complete.digest();
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    public static String readRegString(String key, String value) {
        try {
            int[] handles = (int[])regOpenKey.invoke((Object)systemRoot, -2147483646, Security.toCstr(key), 131097);
            if (handles[1] != 0) {
                return null;
            }
            byte[] valb = (byte[])regQueryValueEx.invoke((Object)systemRoot, handles[0], Security.toCstr(value));
            regCloseKey.invoke((Object)systemRoot, handles[0]);
            return valb != null ? new String(valb).trim() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ArrayList<String> readStringSubKeys(String key) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            int[] handles = (int[])regOpenKey.invoke((Object)systemRoot, -2147483646, Security.toCstr(key), 131097);
            if (handles[1] != 0) {
                return results;
            }
            int[] info = (int[])regQueryInfoKey.invoke((Object)systemRoot, handles[0]);
            int count = info[0];
            int maxlen = info[3];
            for (int index = 0; index < count; ++index) {
                byte[] name = (byte[])regEnumKeyEx.invoke((Object)systemRoot, handles[0], index, maxlen + 1);
                results.add(new String(name).trim());
            }
            regCloseKey.invoke((Object)systemRoot, handles[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static int getHardKey() {
        try {
            String key;
            int numPort = 0;
            while ((key = Security.readRegString("SYSTEM\\CurrentControlSet\\Services\\FTDIBUS\\Enum", String.valueOf(numPort))) != null) {
                ++numPort;
                if (!key.contains("PID_6001")) continue;
                int res = 0;
                for (int i = key.length() - 8; i < key.length(); ++i) {
                    res = (res * 11 + key.getBytes()[i]) % 999983;
                }
                return res;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static String getBiostimPort() {
        try {
            String key;
            int numPort = 0;
            while ((key = Security.readRegString("SYSTEM\\CurrentControlSet\\Services\\FTDIBUS\\Enum", String.valueOf(numPort))) != null) {
                ++numPort;
                if (!key.contains("PID_6001")) continue;
                String portkey = "SYSTEM\\CurrentControlSet\\Enum\\FTDIBUS\\VID_0403+PID_6001+" + key.substring(22) + "A\\0000\\Device Parameters";
                return Security.readRegString(portkey, "PortName");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int oneWayFunction(int key) {
        return (int)(((long)key + 4423L) * 5483L % 900817L * 5501L % 999961L);
    }

    public static void checkKeyV0() {
        if (Computer.isWindows()) {
            Main.getConfig().setActivated(Security.oneWayFunction(Security.getHardKey()) == Main.getConfig().activationKey);
            Main.getConfig().setOptionBT(Security.oneWayFunction(Security.getHardKey() + 1357) == Main.getConfig().btKey ? 2 : 0);
        } else {
            Main.getConfig().setActivated(true);
            Main.getConfig().setOptionBT(0);
        }
    }

    private static void verifInstallMac() {
        try {
            String update;
            String jar = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (!jar.startsWith(Computer.absolutePath)) {
                CloudManager.sendJdd("Mauvaise install Mac", new Object[0]);
                Utils.popupAlert(TransientConfig.translate("mauvaise_install_mac"));
            }
            Main.getConfig().isVbs = jar.contains("Biostim.app");
            Main.getConfig().saveConfig();
            if (!Main.getConfig().isVbs && new File(update = Computer.absolutePath + "update.sh").exists()) {
                if (Utils.popupDialog(TransientConfig.translate("finInstallMac"), false)) {
                    ProcessBuilder pb = new ProcessBuilder("/bin/bash", update);
                    pb.start();
                    System.exit(0);
                } else {
                    CloudManager.sendJdd("Refus fin d'install", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void verifLnk() {
        try {
            if (!Main.getConfig().isVbs) {
                String desktop = Computer.readProcessOutput("powershell -NoLogo -NonInteractive \"Write-Host $([System.Environment]::GetFolderPath([System.Environment+SpecialFolder]::Desktop))\"");
                String desktop2 = FileSystemView.getFileSystemView().getHomeDirectory().toString();
                if (!desktop2.equals(desktop)) {
                    CloudManager.sendJdd("home dir : %s != %s", desktop, desktop2);
                }
                String lnk = desktop + "\\Biostim.exe.lnk";
                String target = Computer.readProcessOutput("powershell -NoProfile -Command \"(New-Object -ComObject WScript.Shell).CreateShortcut('" + lnk + "').TargetPath\"");
                Utils.debugInfo("init target lnk : %s", target);
                if (!target.endsWith(".vbs")) {
                    String newTarget = target.replace(".jar", ".vbs");
                    Computer.readProcessOutput("powershell -NoProfile -Command \"$s = New-Object -ComObject WScript.Shell; $sc = $s.CreateShortcut('" + lnk + "'); $sc.TargetPath = '" + newTarget + "'; $sc.Save()\"");
                    target = Computer.readProcessOutput("powershell -NoProfile -Command \"(New-Object -ComObject WScript.Shell).CreateShortcut('" + lnk + "').TargetPath\"");
                    Utils.debugInfo("new target lnk : %s", target);
                    if (target.endsWith(".vbs")) {
                        CloudManager.sendJdd("Modif raccourci en .vbs", new Object[0]);
                    }
                }
                if (target.endsWith(".vbs")) {
                    Main.getConfig().isVbs = true;
                    Main.getConfig().saveConfig();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            if (!Computer.isMac()) {
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                regOpenKey.setAccessible(true);
                regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                regCloseKey.setAccessible(true);
                regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                regQueryValueEx.setAccessible(true);
                regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
                regQueryInfoKey.setAccessible(true);
                regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                regEnumKeyEx.setAccessible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        verifCheckSum = 1;
    }
}

