/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.utils.Utils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Objects;

public class Csv {
    private final ArrayList<ArrayList<String>> content = new ArrayList();

    public Csv(String filename) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(filename))));
            while ((line = r.readLine()) != null) {
                this.content.add(this.decoupe(line, ';', filename, this.content.size()));
            }
            r.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int nbRows() {
        return this.content.size();
    }

    public String get(int row, int col) {
        try {
            return this.content.get(row).get(col);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getInt(int row, int col) {
        return Integer.parseInt(this.content.get(row).get(col));
    }

    public double getDouble(int row, int col) {
        return Double.parseDouble(this.content.get(row).get(col).replace(',', '.'));
    }

    private ArrayList<String> decoupe(String line, char sep, String file, int num) {
        ArrayList<String> res = new ArrayList<String>();
        int pos = 0;
        while (pos < line.length()) {
            int pos_fin;
            if (line.charAt(pos) == '\"') {
                pos_fin = line.indexOf(34, pos + 1);
                while (pos_fin != -1 && line.length() > pos_fin + 1 && line.charAt(pos_fin + 1) == '\"') {
                    pos_fin = line.indexOf(34, pos_fin + 2);
                }
                if (pos_fin == -1) {
                    Utils.debugInfo("line %d incoh\u00e9rente dans %s (%s)", num, file, line);
                    return res;
                }
                res.add(line.substring(pos + 1, pos_fin).replace("\"\"", "\""));
                pos = pos_fin + 2;
                continue;
            }
            pos_fin = line.indexOf(sep, pos);
            if (pos_fin == -1) {
                res.add(line.substring(pos));
                return res;
            }
            res.add(line.substring(pos, pos_fin));
            pos = pos_fin + 1;
        }
        return res;
    }
}

