/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Maths;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.zdata.Profil;
import com.mazet.biostim.zdata.ProfilConcat;
import com.mazet.biostim.zdata.ProfilConcatSimple;
import com.mazet.biostim.zdata.Programme;
import java.util.ArrayList;

public class Pageprogramme {
    public static final int typeBilanPerineal = -2;
    public static final int typeBilanAnorectal = -1;
    public static final int typeStim = 1;
    public static final int typeTarage = 2;
    public static final int typeBFB = 4;
    public static final int typeConcat = 5;
    public static final int typeDessine = 6;
    public static final int typeAjustable = 7;
    public static final int typeCombine = 8;
    public static final int typeAleatoire = 9;
    public static final int typeCatch = 10;
    public static final int typeAPA = 11;
    public static final int typeConcatSimple = 12;
    public static final int typeBalance = 13;
    public static final int typeBalanceCible = 0;
    public static final int typeBalanceLabyrinthe = 1;
    public transient Integer csFreq;
    public transient Integer csLargeur;
    private String info;
    private Integer duree;
    private int type;
    transient boolean isTarage = false;
    private int next;
    private double trepos = 10.0;
    private int nbVoie = 1;
    private double ttravail;
    private double tmontee;
    private double tdescente;
    private int freq = 50;
    private int largeur = 350;
    private int bf;
    private Double ttravail2;
    private Double trepos2;
    private Double tmontee2;
    private Double tdescente2;
    private Integer freq2;
    private Integer largeur2;
    private int attente2Impulsion;
    private Integer largeurL2;
    private Integer freqF2;
    private Integer dissymetrique;
    private Integer hauteTension;
    private Integer impulsionMono;
    private Integer polarite;
    private boolean reposActif;
    private Boolean reposActif2;
    public static final int minLargeur = 100;
    public static final int maxLargeur = 10000;
    public static final int minFreq = 1;
    public static final int maxFreq = 5000;
    public String profilName;
    public ArrayList<Integer> progs = new ArrayList();
    public ArrayList<Integer> nbRepet = new ArrayList();
    public boolean reposIntra = true;
    public ArrayList<ProfilConcatSimple.Motif> motifs = new ArrayList();
    public ArrayList<Integer> aleaProgs;
    public boolean forceRepos = false;
    public ArrayList<Double> dessineT = new ArrayList();
    public ArrayList<Double> dessineY = new ArrayList();
    public int dureeTravail = 10;
    public double initVal = 0.0;
    public int dynHaut = 50;
    public int dynMontee = 10;
    public int dynTravail = 30;
    private boolean bfbAssiste = false;
    public boolean relachement;
    public boolean insuffisant;
    public int designBalance;
    public int taille = 7;
    public int vitesse = 2;

    public boolean isBfbAssiste() {
        return this.bfbAssiste && Main.getConfig().optionBFBAssiste();
    }

    public void setBfbAssiste(boolean bfbAssiste) {
        this.bfbAssiste = bfbAssiste;
    }

    Pageprogramme() {
    }

    Pageprogramme(int type, int voie, int duree, int next) {
        this.type = type;
        this.setNbVoie(voie);
        this.duree = duree;
        this.next = next;
    }

    Pageprogramme(int type) {
        this.type = type;
    }

    Pageprogramme(ArrayList<ProfilConcatSimple.Motif> motifs) {
        this.type = 12;
        this.motifs = motifs;
    }

    Pageprogramme(int designBalance, int taille, int vitesse) {
        this.type = 13;
        this.designBalance = designBalance;
        this.vitesse = vitesse;
        this.taille = taille;
    }

    Pageprogramme(String paramPage, Programme parent, int row, int col) {
        try {
            String[] parts;
            block85: for (String paramString : parts = paramPage.split(";")) {
                String[] param = paramString.split(":");
                switch (param[0].replace(" ", "").toLowerCase()) {
                    case "info": {
                        this.setInfo(param[1].replace("\"", "").replace(" ", ""));
                        continue block85;
                    }
                    case "duree": {
                        this.setDuree(Utils.intOfTime(param[1].replace(" ", "") + ":" + param[2].replace(" ", "")));
                        continue block85;
                    }
                    case "type": {
                        this.setType(this.typeOfString(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "nbvoie": {
                        this.setNbVoie(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "ttravail": {
                        this.setTtravail(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "dureerepos": 
                    case "trepos": {
                        this.setTrepos(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "tmontee": {
                        this.setTmontee(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "tdescente": {
                        this.setTdescente(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "freq": {
                        this.setFreq(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "largeur": {
                        this.setLargeur(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "ttravail2": {
                        this.ttravail2 = Double.parseDouble(param[1].replace(" ", "").replace(",", "."));
                        continue block85;
                    }
                    case "trepos2": {
                        this.setTrepos2(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "tmontee2": {
                        this.setTmontee2(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "tdescente2": {
                        this.setTdescente2(Double.parseDouble(param[1].replace(" ", "").replace(",", ".")));
                        continue block85;
                    }
                    case "freq2": {
                        this.setFreq2(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "largeur2": {
                        this.setLargeur2(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "bf": {
                        this.setBf(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "profil": {
                        this.setProfilName(param[1].replace(" ", ""));
                        continue block85;
                    }
                    case "voie1enbas": {
                        parent.voie1EnHaut = false;
                        continue block85;
                    }
                    case "defilement": {
                        parent.setDefilement(Integer.parseInt(param[1].replace(" ", "")) != 0);
                        continue block85;
                    }
                    case "voieb": {
                        parent.setVoieBFB2(1);
                        continue block85;
                    }
                    case "voieano": {
                        parent.setVoieBFB1(Main.getConfig().anorectalPression ? 2 : 0);
                        continue block85;
                    }
                    case "voieano2": {
                        parent.setVoieBFB2(Main.getConfig().anorectalPression ? 3 : 2);
                        parent.tarage2 = 150;
                        continue block85;
                    }
                    case "voiep": {
                        parent.setVoieBFB1(2);
                        continue block85;
                    }
                    case "voiep2": {
                        parent.setVoieBFB2(3);
                        continue block85;
                    }
                    case "voiebb": {
                        parent.setVoieBFB1(8);
                        continue block85;
                    }
                    case "animation": {
                        parent.choixBFB = Integer.parseInt(param[1].replace(" ", ""));
                        continue block85;
                    }
                    case "next": {
                        this.setNext(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "f2": {
                        this.setFreqF2(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "l2": {
                        this.setLargeurL2(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "reposactif": {
                        this.reposActif = true;
                        continue block85;
                    }
                    case "reposactif2": {
                        this.reposActif2 = true;
                        continue block85;
                    }
                    case "dynhaut": {
                        this.dynHaut = Integer.parseInt(param[1].replace(" ", ""));
                        continue block85;
                    }
                    case "dynmontee": {
                        this.dynMontee = Integer.parseInt(param[1].replace(" ", ""));
                        continue block85;
                    }
                    case "dyntravail": {
                        this.dynTravail = Integer.parseInt(param[1].replace(" ", ""));
                        continue block85;
                    }
                    case "page": {
                        this.progs.add(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "repet": {
                        this.nbRepet.add(Integer.parseInt(param[1].replace(" ", "")));
                        continue block85;
                    }
                    case "reposintra": {
                        this.reposIntra = Integer.parseInt(param[1].replace(" ", "")) != 0;
                        this.forceRepos = !this.reposIntra;
                        continue block85;
                    }
                    case "concatsimple": {
                        this.setType(12);
                        this.motifs.add(new ProfilConcatSimple.Motif(1, Integer.parseInt(param[1].replace(" ", "")), 1.0, (double)Integer.parseInt(param[2].replace(" ", ""))));
                        continue block85;
                    }
                    default: {
                        Utils.popupAlert("erreur dans le fichier programme, ligne " + (row + 1) + ", colonne" + (col + 1) + " : param\u00e8tre inconnu pour une page (" + param[0] + ")\n\n" + paramString);
                    }
                }
            }
        }
        catch (Exception e) {
            Utils.debugLine("erreur dans le fichier programme, ligne %d, colonne%d (%s)", row + 1, col + 1, paramPage);
            e.printStackTrace();
        }
    }

    private int typeOfString(String type) {
        switch (type.toLowerCase()) {
            case "stim": {
                return 1;
            }
            case "bfb": {
                return 4;
            }
            case "concat": {
                return 5;
            }
            case "concatsimple": {
                return 12;
            }
            case "dessine": {
                return 6;
            }
            case "ajustable": {
                return 7;
            }
            case "aleatoire": {
                return 9;
            }
            case "combine": {
                return 8;
            }
            case "catch": {
                return 10;
            }
            case "bilananorectal": {
                return -1;
            }
            case "bilanperineal": {
                return -2;
            }
            case "apa": {
                return 11;
            }
            case "balance": {
                return 13;
            }
        }
        Utils.popupAlert("erreur dans le fichier programme : type de page inconnue (" + type + ")");
        return 0;
    }

    void makeStatic(ArrayList<Programme> listProg, Programme p) {
        try {
            this.bfbAssiste = false;
            this.profilName = String.format("__%d_%d", p.getId(), p.getListPage().indexOf(this));
            if (!Profil.existTempProfil(this.profilName)) {
                double temp = this.trepos;
                this.trepos = 0.0;
                Profil profil = this.getProfil(listProg);
                profil.setName(this.profilName);
                Profil.addTempProfil(profil);
                this.trepos = temp;
            }
            this.type = 4;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getImax(int freq, int largeur) {
        double correc = (double)(2 * freq * largeur) * 1.0E-6;
        if (correc >= 1.0) {
            return 0;
        }
        double iEffMax = freq <= 400 ? 50.0 : (double)(freq <= 1500 ? 80 : 100);
        double iMax = iEffMax / Math.sqrt(correc);
        return Math.min(100, (int)Math.floor(iMax));
    }

    public int getImaxA() {
        return Pageprogramme.getImax(this.freq, this.getLargeur());
    }

    public int getImaxB() {
        return Pageprogramme.getImax(this.getFreq2(), this.getLargeur2());
    }

    public void copyParams(Pageprogramme pageACopier) {
        this.duree = pageACopier.duree;
        this.trepos = pageACopier.trepos;
        this.nbVoie = pageACopier.nbVoie;
        this.ttravail = pageACopier.ttravail;
        this.tmontee = pageACopier.tmontee;
        this.tdescente = pageACopier.tdescente;
        this.freq = pageACopier.freq;
        this.largeur = pageACopier.largeur;
        this.ttravail2 = pageACopier.ttravail2;
        this.trepos2 = pageACopier.trepos2;
        this.tmontee2 = pageACopier.tmontee2;
        this.tdescente2 = pageACopier.tdescente2;
        this.freq2 = pageACopier.freq2;
        this.largeur2 = pageACopier.largeur2;
        this.freqF2 = pageACopier.freqF2;
        this.largeurL2 = pageACopier.largeurL2;
        this.progs = pageACopier.progs;
        this.nbRepet = pageACopier.nbRepet;
        this.reposIntra = pageACopier.reposIntra;
        this.motifs = pageACopier.motifs;
        this.aleaProgs = pageACopier.aleaProgs;
        this.forceRepos = pageACopier.forceRepos;
        this.dessineT = pageACopier.dessineT;
        this.dessineY = pageACopier.dessineY;
        this.dureeTravail = pageACopier.dureeTravail;
        this.initVal = pageACopier.initVal;
        this.dynHaut = pageACopier.dynHaut;
        this.dynMontee = pageACopier.dynMontee;
        this.dynTravail = pageACopier.dynTravail;
        this.bfbAssiste = pageACopier.bfbAssiste;
        this.relachement = pageACopier.relachement;
        this.insuffisant = pageACopier.insuffisant;
        this.vitesse = pageACopier.vitesse;
        this.taille = pageACopier.taille;
    }

    public String getInfo() {
        return this.info;
    }

    void setInfo(String info) {
        this.info = info;
    }

    public Integer getDuree() {
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
        if (this.duree < 5) {
            this.duree = 5;
        }
        if (this.duree > 3600) {
            this.duree = 3600;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Profil getProfil() {
        return this.getProfil(null);
    }

    public boolean containStim() {
        if (this.getType() == 1) {
            return true;
        }
        if (this.getType() == 7 && this.isBfbAssiste()) {
            return true;
        }
        if (this.getType() == 12) {
            for (ProfilConcatSimple.Motif motif : this.motifs) {
                if (motif.nbPic != -1) continue;
                return true;
            }
        }
        return false;
    }

    private Profil getProfil(ArrayList<Programme> allProgs) {
        if (this.type == 4) {
            return Profil.getProfilByName(this.profilName, this.trepos);
        }
        if (!(this.type != 5 && this.type != 9 || this.progs.isEmpty())) {
            ArrayList<Pageprogramme> profils = new ArrayList<Pageprogramme>();
            if (allProgs == null) {
                allProgs = Programme.getAllProgrammes();
            }
            for (int id : this.progs) {
                for (Programme p : allProgs) {
                    if (id != p.getId()) continue;
                    profils.add(p.getFirstPage());
                }
            }
            return new ProfilConcat(profils, this.nbRepet, this.trepos, this.reposIntra, this.forceRepos);
        }
        if (this.type == 12 && !this.motifs.isEmpty()) {
            return new ProfilConcatSimple(this.motifs);
        }
        if (this.type == 6) {
            return new Profil(this.dessineT, this.dessineY, this.dureeTravail, this.trepos, this.initVal);
        }
        if (this.type == 7) {
            return new Profil((double)this.dynHaut / 100.0, (double)this.dynMontee / 10.0, (double)this.dynTravail / 10.0, this.trepos);
        }
        if (this.type == 10 || this.type == 11 || this.type == 13) {
            return new Profil(0.0, 0.0, this.dureeTravail, 0.0);
        }
        if (this.type == 9) {
            int pos;
            ArrayList<Integer> goodProgs = new ArrayList<Integer>();
            ArrayList<Integer> goodRepet = new ArrayList<Integer>();
            ArrayList<Double> durees = new ArrayList<Double>();
            for (int id : this.aleaProgs) {
                Pageprogramme pp = Programme.getProgById(id).getFirstPage();
                if (pp.type == 5) {
                    int id2 = pp.progs.get(0);
                    Pageprogramme pp2 = Programme.getProgById(id2).getFirstPage();
                    double t = pp2.getDureeTravailProfil();
                    if (!(t > 0.0)) continue;
                    goodProgs.add(id2);
                    goodRepet.add(pp.nbRepet.get(0));
                    durees.add(t * (double)pp.nbRepet.get(0).intValue());
                    continue;
                }
                double t = pp.getDureeTravailProfil();
                if (!(t > 0.0)) continue;
                goodProgs.add(id);
                goodRepet.add(1);
                durees.add(t);
            }
            if (goodProgs.isEmpty()) {
                return null;
            }
            for (double dureeTotale = 0.0; dureeTotale < 60.0; dureeTotale += ((Double)durees.get(pos)).doubleValue()) {
                pos = (int)Math.floor(Math.random() * (double)goodProgs.size());
                this.progs.add((Integer)goodProgs.get(pos));
                this.nbRepet.add((Integer)goodRepet.get(pos));
            }
            this.reposIntra = false;
            return this.getProfil(allProgs);
        }
        return null;
    }

    private double getDureeTravailProfil() {
        if (this.type == 4) {
            return Profil.getProfilDureeByName(this.profilName);
        }
        if (this.type == 6) {
            return this.dureeTravail;
        }
        if (this.type == 7) {
            return (double)(2 * this.dynMontee) / 10.0 + (double)this.dynTravail / 10.0;
        }
        if (this.type == 5 && this.progs.size() == 1) {
            return Programme.getProgById(this.progs.get(0)).getFirstPage().getDureeTravailProfil() * (double)this.nbRepet.get(0).intValue();
        }
        if (this.type == 12) {
            double total = 0.0;
            for (ProfilConcatSimple.Motif motif : this.motifs) {
                total += motif.getDureeTravail();
            }
            return total;
        }
        return -1.0;
    }

    Profil getProfilForceRepos(double repos) {
        if (this.type == 4) {
            return Profil.getProfilByName(this.profilName, repos);
        }
        if (this.type == 5 && !this.progs.isEmpty()) {
            ArrayList<Pageprogramme> profils = new ArrayList<Pageprogramme>();
            ArrayList<Programme> allProgs = Programme.getAllProgrammes();
            for (int id : this.progs) {
                for (Programme p : allProgs) {
                    if (id != p.getId()) continue;
                    profils.add(p.getFirstPage());
                }
            }
            return new ProfilConcat(profils, this.nbRepet, repos, false, true);
        }
        if (this.type == 12 && !this.motifs.isEmpty()) {
            return new ProfilConcatSimple(this.motifs);
        }
        if (this.type == 6) {
            return new Profil(this.dessineT, this.dessineY, this.dureeTravail, repos, this.initVal);
        }
        if (this.type == 7) {
            return new Profil((double)this.dynHaut / 100.0, (double)this.dynMontee / 10.0, (double)this.dynTravail / 10.0, repos);
        }
        return null;
    }

    public void initAleaIfNull(ArrayList<Programme> allProgs) {
        if (this.aleaProgs == null) {
            this.aleaProgs = new ArrayList();
            if (allProgs == null) {
                allProgs = Programme.getProgrammesConcat();
            }
            for (Programme p : allProgs) {
                if (p.getId() >= 100) continue;
                this.aleaProgs.add(p.getId());
            }
        }
    }

    public int getNbVoie() {
        return this.nbVoie;
    }

    public void setNbVoie(int nbVoie) {
        this.nbVoie = nbVoie;
    }

    public double getTtravail() {
        return this.ttravail;
    }

    public void setTtravail(double ttravail) {
        this.ttravail = Math.min(Math.max(ttravail, Math.max(0.1, this.tmontee + this.tdescente)), 1800.0);
        this.ttravail = (double)Math.round(this.ttravail * 10.0) / 10.0;
    }

    public double getTrepos() {
        return this.trepos;
    }

    public void setTrepos(double trepos) {
        this.trepos = Math.min(Math.max(trepos, 0.0), 1800.0);
        this.trepos = (double)Math.round(this.trepos * 10.0) / 10.0;
    }

    public void incrTrepos(int sign) {
        this.setTrepos(this.trepos + (double)sign * Utils.getDoubleDelta(this.trepos));
    }

    public double getTmontee() {
        return this.tmontee;
    }

    public void setTmontee(double tmontee) {
        this.tmontee = this.ttravail == 0.0 ? tmontee : Math.min(Math.max(tmontee, 0.0), this.ttravail - this.getTdescente());
        this.tmontee = (double)Math.round(this.tmontee * 10.0) / 10.0;
    }

    public double getTdescente() {
        return this.tdescente;
    }

    public void setTdescente(double tdescente) {
        this.tdescente = Math.min(Math.max(tdescente, 0.0), this.ttravail - this.getTmontee());
        this.tdescente = (double)Math.round(this.tdescente * 10.0) / 10.0;
    }

    public int getFreq() {
        if (this.csFreq != null) {
            return this.csFreq;
        }
        return this.freq;
    }

    public void setFreq(int freq) {
        this.freq = Math.min(Math.max(freq, 1), 5000);
    }

    public int getLargeur() {
        if (this.csLargeur != null) {
            return this.csLargeur;
        }
        return this.largeur;
    }

    public void setLargeur(int largeur) {
        this.largeur = Math.min(Math.max(largeur, 100), 10000);
    }

    public int getBf() {
        return this.bf;
    }

    public void setBf(int bf) {
        this.bf = bf;
    }

    public int getAttente2Impulsion() {
        return this.attente2Impulsion;
    }

    void setAttente2Impulsion(int attente2Impulsion) {
        this.attente2Impulsion = attente2Impulsion;
    }

    public int getLargeurL2() {
        if (this.largeurL2 == null) {
            return 0;
        }
        return this.largeurL2;
    }

    public void setLargeurL2(int largeurL2) {
        this.largeurL2 = largeurL2 == 0 ? Integer.valueOf(0) : Integer.valueOf(Math.min(Math.max(largeurL2, 100), 10000));
    }

    public int getFreqF2() {
        if (this.freqF2 == null) {
            return 0;
        }
        return this.freqF2;
    }

    public void setFreqF2(int freqF2) {
        this.freqF2 = Math.min(freqF2, 5000);
    }

    public String getPrintLargeur() {
        String res = Integer.toString(this.getLargeur());
        if (this.getLargeurL2() != 0) {
            res = this.getLargeur() + " ~ " + this.getLargeurL2();
        }
        return res;
    }

    public String getPrintFreq() {
        String res = Integer.toString(this.getFreq());
        if (this.getFreqF2() != 0) {
            res = this.getFreq() + " ~ " + this.getFreqF2();
        }
        if (this.getBf() != 0) {
            res = res + "\n(" + TransientConfig.translate("BF") + " " + this.getBf() + "Hz)";
        }
        return res;
    }

    public String getPrintLargeur2() {
        String res = Integer.toString(this.getLargeur2());
        if (this.getLargeurL2() != 0) {
            res = this.getLargeur2() + " ~ " + this.getLargeurL2();
        }
        return res;
    }

    public String getPrintFreq2() {
        String res = Integer.toString(this.getFreq2());
        if (this.getFreqF2() != 0) {
            res = this.getFreq2() + " ~ " + this.getFreqF2();
        }
        if (this.getBf() != 0) {
            res = res + "\n(" + TransientConfig.translate("BF") + " " + this.getBf() + "Hz)";
        }
        return res;
    }

    public void setFreq(String freq) {
    }

    public int getDissymetrique() {
        if (this.dissymetrique == null) {
            return 0;
        }
        return this.dissymetrique;
    }

    void setDissymetrique(int dissymetrique) {
        this.dissymetrique = dissymetrique;
    }

    public int getHauteTension() {
        if (this.hauteTension == null) {
            return 0;
        }
        return this.hauteTension;
    }

    void setHauteTension(int hauteTension) {
        this.hauteTension = hauteTension;
    }

    public int getImpulsionMono() {
        if (this.impulsionMono == null) {
            return 0;
        }
        return this.impulsionMono;
    }

    void setImpulsionMono(int impulsionMono) {
        this.impulsionMono = impulsionMono;
    }

    public int getPolarite() {
        if (this.polarite == null) {
            return 0;
        }
        return this.polarite;
    }

    void setPolarite(int polarite) {
        this.polarite = polarite;
    }

    public int getLargeurL3() {
        if (this.largeurL2 == null || this.largeurL2 == 0) {
            return 0;
        }
        return this.largeur;
    }

    public int getFreqF3() {
        if (this.freqF2 == null || this.freqF2 == 0) {
            return 0;
        }
        return this.freq;
    }

    public double getTtravail2() {
        if (this.ttravail2 == null) {
            this.ttravail2 = this.ttravail;
        }
        return this.ttravail2;
    }

    public void setTtravail2(double ttravail2) {
        this.ttravail2 = Math.min(Math.max(ttravail2, Math.max(0.1, this.getTmontee2() + this.getTdescente2())), 1800.0);
        this.ttravail2 = (double)Math.round(this.ttravail2 * 10.0) / 10.0;
    }

    public double getTrepos2() {
        if (this.trepos2 == null) {
            this.setTrepos2(this.trepos);
        }
        return this.trepos2;
    }

    public void setTrepos2(double trepos2) {
        this.trepos2 = Math.min(Math.max(trepos2, 0.0), 1800.0);
        this.trepos2 = (double)Math.round(this.trepos2 * 10.0) / 10.0;
    }

    public double getTmontee2() {
        if (this.tmontee2 == null) {
            this.tmontee2 = this.tmontee;
        }
        return this.tmontee2;
    }

    public void setTmontee2(double tmontee2) {
        this.tmontee2 = this.ttravail == 0.0 ? Double.valueOf(tmontee2) : Double.valueOf(Math.min(Math.max(tmontee2, 0.0), this.ttravail2 - this.getTdescente2()));
        this.tmontee2 = (double)Math.round(this.tmontee2 * 10.0) / 10.0;
    }

    public double getTdescente2() {
        if (this.tdescente2 == null) {
            this.tdescente2 = this.tdescente;
        }
        return this.tdescente2;
    }

    public void setTdescente2(double tdescente2) {
        this.tdescente2 = Math.min(Math.max(tdescente2, 0.0), this.ttravail2 - this.getTmontee2());
        this.tdescente2 = (double)Math.round(this.tdescente2 * 10.0) / 10.0;
    }

    public int getFreq2() {
        if (this.freq2 == null) {
            this.setFreq2(this.getFreq());
        }
        return this.freq2;
    }

    public void setFreq2(int freq2) {
        this.freq2 = Math.min(Math.max(freq2, 1), 5000);
    }

    public int getLargeur2() {
        if (this.largeur2 == null) {
            this.setLargeur2(this.getLargeur());
        }
        return this.largeur2;
    }

    public void setLargeur2(int largeur2) {
        this.largeur2 = Math.min(Math.max(largeur2, 100), 10000);
    }

    public boolean getReposActif() {
        return this.reposActif;
    }

    public boolean getReposActif2() {
        if (this.reposActif2 == null) {
            this.reposActif2 = this.reposActif;
        }
        return this.reposActif2;
    }

    public int getNext() {
        return this.next;
    }

    public void setNext(int next) {
        this.next = next;
    }

    private void setProfilName(String profil) {
        this.profilName = profil;
    }

    public void incrDynHaut(int delta) {
        this.dynHaut += delta * 5;
        this.dynHaut = this.dynHaut < 0 ? 0 : Math.min(this.dynHaut, 100);
    }

    public void incrDynTravail(int delta) {
        this.dynTravail += delta;
        this.dynTravail = this.dynTravail < 0 ? 0 : Math.min(this.dynTravail, 600);
    }

    public void incrDynMontee(int delta) {
        this.dynMontee += delta;
        this.dynMontee = this.dynMontee < 0 ? 0 : Math.min(this.dynMontee, 100);
    }

    public void incrDureeTravail(int delta) {
        this.dureeTravail += delta;
        this.dureeTravail = this.dureeTravail < 1 ? 1 : Math.min(this.dureeTravail, 100);
    }

    public double getStimAmplitude1(double time) {
        double total = this.ttravail + this.trepos;
        if ((time %= total) < this.tmontee) {
            return Maths.interpolation(0.0, this.tmontee, 0.0, 1.0, time);
        }
        if (time < this.ttravail - this.tdescente) {
            return 1.0;
        }
        if (time < this.ttravail) {
            return Maths.interpolation(this.ttravail - this.tdescente, this.ttravail, 1.0, 0.0, time);
        }
        return 0.0;
    }

    public double getPeriode1() {
        return this.ttravail + this.trepos;
    }

    public double getPeriode2() {
        return this.getTtravail2() + this.getTrepos2();
    }

    public boolean isPlateau1(double time) {
        double total = this.ttravail + this.trepos;
        return (time %= total) > this.tmontee && time <= this.ttravail - this.tdescente;
    }

    public double getStimAmplitude2(double time) {
        double total = this.getTtravail2() + this.getTrepos2();
        if ((time %= total) < this.getTmontee2()) {
            return Maths.interpolation(0.0, this.tmontee2, 0.0, 1.0, time);
        }
        if (time < this.ttravail2 - this.getTdescente2()) {
            return 1.0;
        }
        if (time < this.ttravail2) {
            return Maths.interpolation(this.ttravail2 - this.tdescente2, this.ttravail2, 1.0, 0.0, time);
        }
        return 0.0;
    }

    public boolean isPlateau2(double time) {
        double total = this.ttravail2 + this.trepos2;
        return (time %= total) > this.tmontee2 && time <= this.ttravail2 - this.tdescente2;
    }

    public double getZeroTime(double time) {
        double total = this.ttravail + this.trepos;
        double time1 = time % total;
        if (time1 < this.ttravail) {
            return 0.0;
        }
        double res1 = total - time1;
        total = this.getTtravail2() + this.getTrepos2();
        double time2 = time % total;
        if (time2 <= this.ttravail2) {
            return 0.0;
        }
        return Math.min(res1, total - time2);
    }
}

