/*
 * Decompiled with CFR 0.152.
 */
package jwave;

import jwave.datatypes.natives.Complex;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;
import jwave.transforms.wavelets.Wavelet;

public final class Transform {
    protected final BasicTransform _basicTransform;

    public Transform(BasicTransform basicTransform) {
        this._basicTransform = basicTransform;
        try {
            if (this._basicTransform == null) {
                throw new JWaveFailure("given object is null!");
            }
            if (!(this._basicTransform instanceof BasicTransform)) {
                throw new JWaveFailure("given object is not of type BasicTransform");
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
    }

    public final double[] forward(double[] dArray) {
        double[] dArray2 = null;
        try {
            dArray2 = this._basicTransform.forward(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[] reverse(double[] dArray) {
        double[] dArray2 = null;
        try {
            dArray2 = this._basicTransform.reverse(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[] forward(double[] dArray, int n) {
        double[] dArray2 = null;
        try {
            dArray2 = this._basicTransform.forward(dArray, n);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[] reverse(double[] dArray, int n) {
        double[] dArray2 = null;
        try {
            dArray2 = this._basicTransform.reverse(dArray, n);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final Complex[] forward(Complex[] complexArray) {
        Complex[] complexArray2 = null;
        try {
            complexArray2 = this._basicTransform.forward(complexArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return complexArray2;
    }

    public final Complex[] reverse(Complex[] complexArray) {
        Complex[] complexArray2 = null;
        try {
            complexArray2 = this._basicTransform.reverse(complexArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return complexArray2;
    }

    public final double[][] forward(double[][] dArray) {
        double[][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.forward(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][] reverse(double[][] dArray) {
        double[][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.reverse(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][] forward(double[][] dArray, int n, int n2) {
        double[][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.forward(dArray, n, n2);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][] reverse(double[][] dArray, int n, int n2) {
        double[][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.reverse(dArray, n, n2);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][][] forward(double[][][] dArray) {
        double[][][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.forward(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][][] reverse(double[][][] dArray) {
        double[][][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.reverse(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][][] forward(double[][][] dArray, int n, int n2, int n3) {
        double[][][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.forward(dArray, n, n2, n3);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][][] reverse(double[][][] dArray, int n, int n2, int n3) {
        double[][][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.reverse(dArray, n, n2, n3);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[][] decompose(double[] dArray) {
        double[][] dArray2 = null;
        try {
            dArray2 = this._basicTransform.decompose(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[] recompose(double[][] dArray) {
        double[] dArray2 = null;
        try {
            dArray2 = this._basicTransform.recompose(dArray);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final double[] recompose(double[][] dArray, int n) {
        double[] dArray2 = null;
        try {
            dArray2 = this._basicTransform.recompose(dArray, n);
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return dArray2;
    }

    public final BasicTransform getBasicTransform() {
        BasicTransform basicTransform = null;
        try {
            if (this._basicTransform == null) {
                throw new JWaveFailure("Transform - BasicTransform object is null!");
            }
            if (!(this._basicTransform instanceof BasicTransform)) {
                throw new JWaveFailure("Transform - getBasicTransform - member is not of type BasicTransform!");
            }
            basicTransform = this._basicTransform;
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return basicTransform;
    }

    public final Wavelet getWavelet() {
        Wavelet wavelet = null;
        BasicTransform basicTransform = null;
        try {
            basicTransform = this.getBasicTransform();
            wavelet = basicTransform.getWavelet();
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return wavelet;
    }
}

