/*
 * Decompiled with CFR 0.152.
 */
package jwave;

import java.util.Random;
import jwave.Transform;
import jwave.TransformBuilder;
import jwave.compressions.Compressor;
import jwave.compressions.CompressorMagnitude;
import jwave.datatypes.natives.Complex;
import jwave.exceptions.JWaveFailure;
import jwave.tools.MathToolKit;
import jwave.transforms.DiscreteFourierTransform;
import jwave.transforms.FastWaveletTransform;
import jwave.transforms.WaveletPacketTransform;
import jwave.transforms.wavelets.Wavelet;
import jwave.transforms.wavelets.WaveletBuilder;
import jwave.transforms.wavelets.haar.Haar1;
import jwave.transforms.wavelets.haar.Haar1Orthogonal;
import jwave.transforms.wavelets.legendre.Legendre1;
import jwave.transforms.wavelets.legendre.Legendre2;
import jwave.transforms.wavelets.legendre.Legendre3;
import jwave.transforms.wavelets.other.DiscreteMayer;
import org.junit.Assert;
import org.junit.Test;

public class TransformTest {
    @Test
    public void testSampling() {
        int n = 0x100000;
        int n2 = 1024;
        double[] dArray = MathToolKit.createSineOscillation(n, n2);
        Transform transform = TransformBuilder.create("Fast Wavelet Transform", "Haar");
        double[] dArray2 = transform.forward(dArray);
        double[] dArray3 = transform.reverse(dArray2);
        this.assertArray(dArray, dArray3, 1.0E-10);
        dArray = MathToolKit.createCosineOscillation(n, n2);
        dArray2 = transform.forward(dArray);
        dArray3 = transform.reverse(dArray2);
        this.assertArray(dArray, dArray3, 1.0E-10);
    }

    @Test
    public void testDFT() throws JWaveFailure {
        int n = 8;
        int n2 = 1;
        Transform transform = new Transform(new DiscreteFourierTransform());
        System.out.println(" ");
        double[] dArray = MathToolKit.createSineOscillation(n, n2);
        this.showTime(dArray);
        double[] dArray2 = transform.forward(dArray);
        this.showFreq(dArray2);
        double[] dArray3 = transform.reverse(dArray2);
        this.showTime(dArray3);
        this.assertArray(dArray, dArray3, 1.0E-10);
        System.out.println(" ");
        double[] dArray4 = MathToolKit.createCosineOscillation(n, n2);
        this.showTime(dArray4);
        double[] dArray5 = transform.forward(dArray4);
        this.showFreq(dArray5);
        double[] dArray6 = transform.reverse(dArray5);
        this.showTime(dArray6);
        this.assertArray(dArray4, dArray6, 1.0E-10);
        transform = TransformBuilder.create("Fast Wavelet Transform", "Haar");
        dArray = MathToolKit.createSineOscillation(n, n2);
        dArray2 = transform.forward(dArray);
        dArray3 = transform.reverse(dArray2);
        this.assertArray(dArray, dArray3, 1.0E-10);
        dArray5 = transform.forward(dArray4);
        dArray6 = transform.reverse(dArray5);
        this.assertArray(dArray4, dArray6, 1.0E-10);
    }

    @Test
    public void testRounding() {
        System.out.println("");
        System.out.println("testRounding");
        System.out.println("");
        int n = 1024;
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0;
        }
        double d = 1.0E-8;
        for (Wavelet wavelet : WaveletBuilder.create2arr()) {
            this.testFastWaveletTransformRounding(dArray, wavelet, d);
            this.testWaveletPacketTransformRounding(dArray, wavelet, d);
            System.out.println("");
        }
        System.out.println("testRounding Haar Orthogonal - 1000 transforms => rounding error: " + d);
        this.testFastWaveletTransformRounding(dArray, new Haar1Orthogonal(), d);
        this.testWaveletPacketTransformRounding(dArray, new Haar1Orthogonal(), d);
        System.out.println("");
        System.out.println("testRounding Legendre 1 - 1000 transforms => rounding error: " + d);
        this.testFastWaveletTransformRounding(dArray, new Legendre1(), d);
        this.testWaveletPacketTransformRounding(dArray, new Legendre1(), d);
        System.out.println("");
        System.out.println("testRounding Legendre 2 - 1000 transforms => rounding error: " + d);
        this.testFastWaveletTransformRounding(dArray, new Legendre2(), d);
        this.testWaveletPacketTransformRounding(dArray, new Legendre2(), d);
        System.out.println("");
        System.out.println("testRounding Legendre 3 - 1000 transforms => rounding error: " + d);
        this.testFastWaveletTransformRounding(dArray, new Legendre3(), d);
        this.testWaveletPacketTransformRounding(dArray, new Legendre3(), d);
        System.out.println("");
        System.out.println("testRounding Discrete Mayer - 1000 transforms => rounding error: " + d);
        this.testFastWaveletTransformRounding(dArray, new DiscreteMayer(), 0.01);
        System.out.println("");
    }

    @Test
    public void testExample() {
        double d = 1.0E-6;
        for (Wavelet wavelet : WaveletBuilder.create2arr()) {
            System.out.println("Testing example with FWT using " + wavelet.getName());
            Transform transform = new Transform(new FastWaveletTransform(wavelet));
            double[] dArray = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
            double[] dArray2 = transform.forward(dArray);
            double[] dArray3 = transform.reverse(dArray2);
            this.showTime(dArray);
            this.showHilb(dArray2);
            this.showTime(dArray3);
            this.assertArray(dArray, dArray3, d);
            int n = 0x100000;
            double[] dArray4 = new double[n];
            Random random = new Random();
            for (int i = 0; i < n; ++i) {
                dArray4[i] = random.nextDouble();
            }
            double[] dArray5 = transform.forward(dArray4);
            double[] dArray6 = transform.reverse(dArray5);
            this.assertArray(dArray4, dArray6, d);
        }
    }

    @Test
    public void testStepping() {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        double[] dArray4;
        double[] dArray5;
        double[] dArray6;
        double[] dArray7;
        double[] dArray8;
        double[] dArray9;
        double[] dArray10;
        double[] dArray11;
        double[] dArray12;
        double[] dArray13;
        double[] dArray14;
        double[][] dArrayArray;
        double d;
        double d2;
        double d3;
        double[] dArray15;
        double[] dArray16;
        double[] dArray17;
        double[] dArray18;
        double[] dArray19;
        double[] dArray20;
        double[] dArray21;
        Transform transform;
        double[][] dArrayArray2;
        double d4;
        double[] dArray22;
        Wavelet wavelet;
        int n;
        double d5 = 1.0E-8;
        Wavelet[] waveletArray = WaveletBuilder.create2arr();
        int n2 = waveletArray.length;
        for (n = 0; n < n2; ++n) {
            wavelet = waveletArray[n];
            System.out.println("");
            System.out.println("Testing the Fast Wavelet Transform stepping forward and reverse 1-D methods using " + wavelet.getName() + " and small array");
            dArray22 = new double[]{1.0, 1.0, 1.0, 1.0};
            d4 = Math.sqrt(2.0);
            dArrayArray2 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {d4, d4, 0.0, 0.0}, {2.0, 0.0, 0.0, 0.0}};
            transform = new Transform(new FastWaveletTransform(wavelet));
            dArray21 = transform.forward(dArray22, 0);
            dArray20 = transform.forward(dArray22, 1);
            dArray19 = transform.forward(dArray22, 2);
            this.assertArray(dArrayArray2[0], dArray21, d5);
            this.assertArray(dArrayArray2[1], dArray20, d5);
            this.assertArray(dArrayArray2[2], dArray19, d5);
            dArray18 = transform.reverse(dArray21, 0);
            dArray17 = transform.reverse(dArray20, 1);
            dArray16 = transform.reverse(dArray19, 2);
            this.assertArray(dArray22, dArray18, d5);
            this.assertArray(dArray22, dArray17, d5);
            this.assertArray(dArray22, dArray16, d5);
            System.out.println("Testing the Fast Wavelet Transform decompose, recompose, and recomposeFromLevel 1-D methods using " + wavelet.getName() + " and long array");
            dArray15 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
            d3 = 1.0 * d4;
            d2 = 2.0 * d3;
            d = 2.0 * d2;
            dArrayArray = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d2, d2, d2, d2, d2, d2, d2, d2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d, d, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
            dArray14 = transform.forward(dArray15, 0);
            this.assertArray(dArrayArray[0], dArray14, d5);
            dArray13 = transform.reverse(dArray14, 0);
            this.assertArray(dArray15, dArray13, d5);
            dArray12 = transform.forward(dArray15, 1);
            this.assertArray(dArrayArray[1], dArray12, d5);
            dArray11 = transform.reverse(dArray12, 1);
            this.assertArray(dArray15, dArray11, d5);
            dArray10 = transform.forward(dArray15, 2);
            this.assertArray(dArrayArray[2], dArray10, d5);
            dArray9 = transform.reverse(dArray10, 2);
            this.assertArray(dArray15, dArray9, d5);
            dArray8 = transform.forward(dArray15, 3);
            this.assertArray(dArrayArray[3], dArray8, d5);
            dArray7 = transform.reverse(dArray8, 3);
            this.assertArray(dArray15, dArray7, d5);
            dArray6 = transform.forward(dArray15, 4);
            this.assertArray(dArrayArray[4], dArray6, d5);
            dArray5 = transform.reverse(dArray6, 4);
            this.assertArray(dArray15, dArray5, d5);
            dArray4 = transform.forward(dArray15, 5);
            this.assertArray(dArrayArray[5], dArray4, d5);
            dArray3 = transform.reverse(dArray4, 5);
            this.assertArray(dArray15, dArray3, d5);
            dArray2 = transform.forward(dArray15, 6);
            this.assertArray(dArrayArray[6], dArray2, d5);
            dArray = transform.reverse(dArray2, 6);
            this.assertArray(dArray15, dArray, d5);
        }
        for (n = 0; n < n2; ++n) {
            wavelet = waveletArray[n];
            System.out.println("");
            System.out.println("Testing the Fast Wavelet Transform stepping forward and reverser 1-D methods using " + wavelet.getName() + " and small array");
            dArray22 = new double[]{1.0, 1.0, 1.0, 1.0};
            d4 = Math.sqrt(2.0);
            dArrayArray2 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {d4, d4, 0.0, 0.0}, {2.0, 0.0, 0.0, 0.0}};
            transform = new Transform(new WaveletPacketTransform(wavelet));
            dArray21 = transform.forward(dArray22, 0);
            dArray20 = transform.forward(dArray22, 1);
            dArray19 = transform.forward(dArray22, 2);
            this.assertArray(dArrayArray2[0], dArray21, d5);
            this.assertArray(dArrayArray2[1], dArray20, d5);
            this.assertArray(dArrayArray2[2], dArray19, d5);
            dArray18 = transform.reverse(dArray21, 0);
            dArray17 = transform.reverse(dArray20, 1);
            dArray16 = transform.reverse(dArray19, 2);
            this.assertArray(dArray22, dArray18, d5);
            this.assertArray(dArray22, dArray17, d5);
            this.assertArray(dArray22, dArray16, d5);
            System.out.println("Testing the Fast Wavelet Transform decompose, recompose, and recomposeFromLevel 1-D methods using " + wavelet.getName() + " and long array");
            dArray15 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
            d3 = 1.0 * d4;
            d2 = 2.0 * d3;
            d = 2.0 * d2;
            dArrayArray = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d2, d2, d2, d2, d2, d2, d2, d2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d, d, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
            dArray14 = transform.forward(dArray15, 0);
            this.assertArray(dArrayArray[0], dArray14, d5);
            dArray13 = transform.reverse(dArray14, 0);
            this.assertArray(dArray15, dArray13, d5);
            dArray12 = transform.forward(dArray15, 1);
            this.assertArray(dArrayArray[1], dArray12, d5);
            dArray11 = transform.reverse(dArray12, 1);
            this.assertArray(dArray15, dArray11, d5);
            dArray10 = transform.forward(dArray15, 2);
            this.assertArray(dArrayArray[2], dArray10, d5);
            dArray9 = transform.reverse(dArray10, 2);
            this.assertArray(dArray15, dArray9, d5);
            dArray8 = transform.forward(dArray15, 3);
            this.assertArray(dArrayArray[3], dArray8, d5);
            dArray7 = transform.reverse(dArray8, 3);
            this.assertArray(dArray15, dArray7, d5);
            dArray6 = transform.forward(dArray15, 4);
            this.assertArray(dArrayArray[4], dArray6, d5);
            dArray5 = transform.reverse(dArray6, 4);
            this.assertArray(dArray15, dArray5, d5);
            dArray4 = transform.forward(dArray15, 5);
            this.assertArray(dArrayArray[5], dArray4, d5);
            dArray3 = transform.reverse(dArray4, 5);
            this.assertArray(dArray15, dArray3, d5);
            dArray2 = transform.forward(dArray15, 6);
            this.assertArray(dArrayArray[6], dArray2, d5);
            dArray = transform.reverse(dArray2, 6);
            this.assertArray(dArray15, dArray, d5);
        }
    }

    @Test
    public void testDecompose() {
        double d = 1.0E-8;
        for (Wavelet wavelet : WaveletBuilder.create2arr()) {
            System.out.println("");
            System.out.println("Testing the Fast Wavelet Transform decompose, recompose, and recomposeFromLevel 1-D methods using " + wavelet.getName() + " and small array");
            double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0};
            Transform transform = new Transform(new FastWaveletTransform(wavelet));
            double[][] dArray2 = transform.decompose(dArray);
            double d2 = Math.sqrt(2.0);
            double[][] dArrayArray = new double[][]{{1.0, 1.0, 1.0, 1.0}, {d2, d2, 0.0, 0.0}, {2.0, 0.0, 0.0, 0.0}};
            this.assertMatrix(dArrayArray, dArray2, d);
            double[] dArray3 = transform.recompose(dArray2);
            this.assertArray(dArray, dArray3, d);
            double[] dArray4 = transform.recompose(dArray2, 0);
            this.assertArray(dArray, dArray4, d);
            double[] dArray5 = transform.recompose(dArray2, 0);
            this.assertArray(dArray, dArray5, d);
            double[] dArray6 = transform.recompose(dArray2, 0);
            this.assertArray(dArray, dArray6, d);
            System.out.println("Testing the Fast Wavelet Transform decompose, recompose, and recomposeFromLevel 1-D methods using " + wavelet.getName() + " and long array");
            double[] dArray7 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
            double[][] dArray8 = transform.decompose(dArray7);
            double d3 = 1.0 * d2;
            double d4 = 2.0 * d3;
            double d5 = 2.0 * d4;
            double[][] dArrayArray2 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, d3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d4, d4, d4, d4, d4, d4, d4, d4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d5, d5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
            this.assertMatrix(dArrayArray2, dArray8, d);
            double[] dArray9 = transform.recompose(dArray8);
            this.assertArray(dArray7, dArray9, d);
            double[] dArray10 = transform.recompose(dArray8, 0);
            this.assertArray(dArray7, dArray10, d);
            double[] dArray11 = transform.recompose(dArray8, 1);
            this.assertArray(dArray7, dArray11, d);
            double[] dArray12 = transform.recompose(dArray8, 2);
            this.assertArray(dArray7, dArray12, d);
            double[] dArray13 = transform.recompose(dArray8, 3);
            this.assertArray(dArray7, dArray13, d);
            double[] dArray14 = transform.recompose(dArray8, 4);
            this.assertArray(dArray7, dArray14, d);
            double[] dArray15 = transform.recompose(dArray8, 5);
            this.assertArray(dArray7, dArray15, d);
            double[] dArray16 = transform.recompose(dArray8, 6);
            this.assertArray(dArray7, dArray16, d);
        }
    }

    @Test
    public void testComplex() {
        int n;
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 1-D method using Haar1 Wavelet");
        double d = 1.0E-12;
        int n2 = 8;
        Complex[] complexArray = new Complex[n2];
        for (int i = 0; i < n2; ++i) {
            complexArray[i] = new Complex(1.0, 1.0);
        }
        Transform transform = new Transform(new FastWaveletTransform(new Haar1()));
        Complex[] complexArray2 = transform.forward(complexArray);
        Complex[] complexArray3 = new Complex[n2];
        for (n = 0; n < n2; ++n) {
            complexArray3[n] = new Complex(0.0, 0.0);
        }
        complexArray3[0].setReal(4.0);
        this.assertArray(complexArray3, complexArray2, d);
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet");
        complexArray2 = new Complex[n2];
        for (n = 0; n < n2; ++n) {
            complexArray2[n] = new Complex(0.0, 0.0);
        }
        complexArray2[0].setReal(4.0);
        complexArray = transform.reverse(complexArray2);
        complexArray3 = new Complex[n2];
        for (n = 0; n < n2; ++n) {
            complexArray3[n] = new Complex(1.0, 1.0);
        }
        this.assertArray(complexArray3, complexArray, d);
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet");
    }

    @Test
    public void testMatrix() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 2-D method using Haar1 Wavelet");
        double d = 1.0E-12;
        double[][] dArrayArray = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
        Transform transform = new Transform(new FastWaveletTransform(new Haar1()));
        double[][] dArray = transform.forward(dArrayArray);
        double[][] dArrayArray2 = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        this.assertMatrix(dArrayArray2, dArray, d);
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 2-D method using Haar1 Wavelet");
        double[][] dArray2 = transform.reverse(dArray);
        double[][] dArrayArray3 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
        this.assertMatrix(dArrayArray3, dArray2, d);
    }

    @Test
    public void testSpace() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 3-D method using Haar1 Wavelet");
        double d = 1.0E-12;
        double[][][] dArrayArray = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
        Transform transform = new Transform(new FastWaveletTransform(new Haar1()));
        double[][][] dArray = transform.forward(dArrayArray);
        double[][][] dArrayArray2 = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
        this.assertSpace(dArrayArray2, dArray, d);
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 3-D method using Haar1 Wavelet");
        double[][][] dArray2 = transform.reverse(dArray);
        double[][][] dArrayArray3 = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
        this.assertSpace(dArrayArray3, dArray2, d);
    }

    @Test
    public void testCompression() {
        CompressorMagnitude compressorMagnitude = new CompressorMagnitude(1.0);
        for (Wavelet wavelet : WaveletBuilder.create2arr()) {
            System.out.println("Testing example with FWT using " + wavelet.getName());
            Transform transform = new Transform(new FastWaveletTransform(wavelet));
            double[] dArray = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1, 1.2, -0.3, -1.4, -2.5, -1.6, -0.7, 0.6, 1.5};
            double[] dArray2 = transform.forward(dArray);
            double[] dArray3 = ((Compressor)compressorMagnitude).compress(dArray2);
            double[] dArray4 = transform.reverse(dArray3);
            this.showTime(dArray);
            this.showHilb(dArray2);
            this.showHilb(dArray3);
            this.showTime(dArray4);
        }
    }

    public void testFastWaveletTransformRounding(double[] dArray, Wavelet wavelet, double d) {
        long l = 1000L;
        double[] dArray2 = dArray;
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i] = dArray2[i];
        }
        Transform transform = new Transform(new FastWaveletTransform(wavelet));
        System.out.println("testRounding FWT " + wavelet.getName() + " - " + l + " transforms => rounding error: " + d);
        System.out.print("Performing: " + l + " forward and reverse transforms ...");
        for (long i = 0L; i < l; ++i) {
            dArray3 = transform.reverse(transform.forward(dArray3));
        }
        System.out.println("done!");
        this.assertArray(dArray2, dArray3, d);
        double d2 = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d2 += Math.abs(dArray3[i] - dArray2[i]);
        }
        System.out.println("Absolute error: " + d2);
        double d3 = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d3 += Math.abs((dArray3[i] - dArray2[i]) * 100.0 / dArray2[i]);
        }
        System.out.println("Relative error [%]: " + d3);
    }

    public void testWaveletPacketTransformRounding(double[] dArray, Wavelet wavelet, double d) {
        long l = 256L;
        double[] dArray2 = dArray;
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i] = dArray2[i];
        }
        System.out.println("testRounding WPT " + wavelet.getName() + " - " + l + " transforms => rounding error: " + d);
        Transform transform = new Transform(new WaveletPacketTransform(wavelet));
        System.out.print("Performing: " + l + " forward and reverse transforms ...");
        for (long i = 0L; i < l; ++i) {
            dArray3 = transform.reverse(transform.forward(dArray3));
        }
        System.out.println("done!");
        this.assertArray(dArray2, dArray3, d);
        double d2 = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d2 += Math.abs(dArray3[i] - dArray2[i]);
        }
        System.out.println("Absolute error: " + d2);
        double d3 = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d3 += Math.abs((dArray3[i] - dArray2[i]) * 100.0 / dArray2[i]);
        }
        System.out.println("Relative error [%]: " + d3);
    }

    public void assertArray(Complex[] complexArray, Complex[] complexArray2, double d) {
        int n = complexArray.length;
        int n2 = complexArray2.length;
        Assert.assertEquals((long)n, (long)n2);
        for (int i = 0; i < n; ++i) {
            double d2 = complexArray[i].getReal();
            double d3 = complexArray[i].getImag();
            double d4 = complexArray2[i].getReal();
            double d5 = complexArray2[i].getImag();
            Assert.assertEquals((double)d2, (double)d4, (double)d);
            Assert.assertEquals((double)d3, (double)d5, (double)d);
        }
    }

    protected void assertArray(double[] dArray, double[] dArray2, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            Assert.assertEquals((double)dArray[i], (double)dArray2[i], (double)d);
        }
    }

    protected void assertMatrix(double[][] dArray, double[][] dArray2, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                Assert.assertEquals((double)dArray[i][j], (double)dArray2[i][j], (double)d);
            }
        }
    }

    protected void assertSpace(double[][][] dArray, double[][][] dArray2, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    Assert.assertEquals((double)dArray[i][j][k], (double)dArray2[i][j][k], (double)d);
                }
            }
        }
    }

    protected void show(double d) {
        System.out.printf("%6.3f", d);
    }

    protected void showTime(double[] dArray) {
        System.out.print("time domain: \t\t");
        for (int i = 0; i < dArray.length; ++i) {
            this.show(dArray[i]);
            System.out.print(" ");
        }
        System.out.println("");
    }

    protected void showFreq(double[] dArray) {
        System.out.print("frequency domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            this.show(dArray[i]);
            System.out.print(" ");
        }
        System.out.println("");
    }

    protected void showHilb(double[] dArray) {
        System.out.print("Hilbert domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            this.show(dArray[i]);
            System.out.print(" ");
        }
        System.out.println("");
    }

    protected void showTime(Complex[] complexArray) {
        System.out.print("time domain: \t\t");
        for (int i = 0; i < complexArray.length; ++i) {
            System.out.print(complexArray[i].toString() + " ");
        }
        System.out.println("");
    }

    protected void showHilb(Complex[] complexArray) {
        System.out.print("frequency domain: \t");
        for (int i = 0; i < complexArray.length; ++i) {
            System.out.print(complexArray[i].toString() + " ");
        }
        System.out.println("");
    }

    protected void showTime(double[][] dArray) {
        System.out.println("time domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                this.show(dArray[i][j]);
                System.out.print(" ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showFreq(double[][] dArray) {
        System.out.println("frequency domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                this.show(dArray[i][j]);
                System.out.print(" ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showHilb(double[][] dArray) {
        System.out.println("Hilbert domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                this.show(dArray[i][j]);
                System.out.print(" ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showTime(double[][][] dArray) {
        System.out.println("time domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    this.show(dArray[i][j][k]);
                    System.out.print(" ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showFreq(double[][][] dArray) {
        System.out.println("frequency domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    this.show(dArray[i][j][k]);
                    System.out.print(" ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showHilb(double[][][] dArray) {
        System.out.println("Hilbert domain: \t");
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    this.show(dArray[i][j][k]);
                    System.out.print(" ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }
}

