/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.blocks;

import java.util.HashMap;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.lines.Line;
import jwave.datatypes.lines.LineHash;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public class BlockHash
extends Block {
    HashMap<Integer, Line> _hashMapLines = null;

    public BlockHash() {
    }

    public BlockHash(Block block) {
        super(block);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    this.set(i, j, block.get(i, j));
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
        }
    }

    public BlockHash(int n, int n2) {
        super(n, n2);
    }

    public BlockHash(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public Block copy() {
        return new BlockHash(this);
    }

    @Override
    public boolean isAllocated() {
        boolean bl = true;
        if (this._hashMapLines == null) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._hashMapLines = new HashMap();
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._hashMapLines != null) {
            this._hashMapLines.clear();
        }
        this._hashMapLines = null;
    }

    @Override
    public double get(int n, int n2) throws JWaveException {
        this.checkMemory();
        this.check(n, n2);
        Line line = null;
        double d = 0.0;
        if (!this._hashMapLines.containsKey(n2)) {
            throw new JWaveFailure("Line - no value stored for requested i: " + n);
        }
        line = this._hashMapLines.get(n2);
        d = line.get(n);
        return d;
    }

    @Override
    public void set(int n, int n2, double d) throws JWaveException {
        this.checkMemory();
        this.check(n, n2);
        Line line = null;
        if (this._hashMapLines.containsKey(n2)) {
            line = this._hashMapLines.get(n2);
            line.set(n, d);
        } else {
            line = new LineHash(this._offSetRow, this._noOfRows);
            line.alloc();
            line.set(n, d);
            this._hashMapLines.put(n2, line);
        }
    }
}

