/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.blocks;

import jwave.datatypes.Super;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.blocks.BlockFull;
import jwave.datatypes.blocks.BlockHash;
import jwave.exceptions.JWaveException;
import org.junit.Assert;
import org.junit.Test;

public class BlockTest {
    private int _noOfRows = 1000;
    private int _noOfCols = 1000;

    private Block genBlockFullObject(int n, int n2) throws JWaveException {
        BlockFull blockFull = new BlockFull(n, n2);
        ((Super)blockFull).alloc();
        for (int i = 0; i < blockFull.getNoOfRows(); ++i) {
            for (int j = 0; j < blockFull.getNoOfCols(); ++j) {
                ((Block)blockFull).set(i, j, i + j);
            }
        }
        return blockFull;
    }

    private Block genBlockHashObject(int n, int n2) throws JWaveException {
        BlockHash blockHash = new BlockHash(n, n2);
        ((Super)blockHash).alloc();
        for (int i = 0; i < blockHash.getNoOfRows(); ++i) {
            for (int j = 0; j < blockHash.getNoOfCols(); ++j) {
                ((Block)blockHash).set(i, j, i + j);
            }
        }
        return blockHash;
    }

    @Test
    public void testGet() {
        try {
            int n;
            int n2;
            Block block = this.genBlockFullObject(this._noOfRows, this._noOfCols);
            for (n2 = 0; n2 < block.getNoOfRows(); ++n2) {
                for (n = 0; n < block.getNoOfCols(); ++n) {
                    Assert.assertEquals((double)(n2 + n), (double)block.get(n2, n), (double)0.0);
                }
            }
            block = this.genBlockHashObject(this._noOfRows, this._noOfCols);
            for (n2 = 0; n2 < block.getNoOfRows(); ++n2) {
                for (n = 0; n < block.getNoOfCols(); ++n) {
                    Assert.assertEquals((double)(n2 + n), (double)block.get(n2, n), (double)0.0);
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
            Assert.fail((String)"caught exception");
        }
    }

    @Test
    public void testSet() {
        try {
            int n;
            int n2;
            Block block = this.genBlockFullObject(this._noOfRows, this._noOfCols);
            for (n2 = 0; n2 < block.getNoOfRows(); ++n2) {
                for (n = 0; n < block.getNoOfCols(); ++n) {
                    block.set(n2, n, n2 + n + 1);
                }
            }
            for (n2 = 0; n2 < block.getNoOfRows(); ++n2) {
                for (n = 0; n < block.getNoOfCols(); ++n) {
                    Assert.assertEquals((double)(n2 + n + 1), (double)block.get(n2, n), (double)0.0);
                }
            }
            block = this.genBlockHashObject(this._noOfRows, this._noOfCols);
            for (n2 = 0; n2 < block.getNoOfRows(); ++n2) {
                for (n = 0; n < block.getNoOfCols(); ++n) {
                    block.set(n2, n, n2 + n + 1);
                }
            }
            for (n2 = 0; n2 < block.getNoOfRows(); ++n2) {
                for (n = 0; n < block.getNoOfCols(); ++n) {
                    Assert.assertEquals((double)(n2 + n + 1), (double)block.get(n2, n), (double)0.0);
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
            Assert.fail((String)"caught exception");
        }
    }
}

