/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.lines;

import java.util.HashMap;
import jwave.datatypes.Super;
import jwave.datatypes.lines.Line;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailureNotFound;

public class LineHash
extends Line {
    HashMap<Integer, Double> _hashMap;

    public LineHash() {
    }

    public LineHash(Line line) {
        super(line);
        try {
            this.alloc();
            for (int i = 0; i < line._noOfRows; ++i) {
                this.set(i, line.get(i));
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
        }
    }

    public LineHash(int n) {
        super(n);
    }

    public LineHash(int n, int n2) {
        super(n, n2);
    }

    @Override
    public Line copy() {
        int n = this.getOffSetRow();
        int n2 = this.getNoOfRows();
        LineHash lineHash = new LineHash(n, n2);
        try {
            if (this.isAllocated()) {
                ((Super)lineHash).alloc();
                for (int i = 0; i < n2; ++i) {
                    try {
                        ((Line)lineHash).set(i, this.get(i));
                        continue;
                    }
                    catch (JWaveFailureNotFound jWaveFailureNotFound) {
                        continue;
                    }
                    catch (JWaveException jWaveException) {
                        jWaveException.printStackTrace();
                    }
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
        }
        return lineHash;
    }

    @Override
    public boolean isAllocated() {
        boolean bl = true;
        if (this._hashMap == null) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._hashMap = new HashMap();
        }
    }

    @Override
    public void erase() throws JWaveException {
        this._hashMap = null;
    }

    @Override
    public double get(int n) throws JWaveException {
        this.checkMemory();
        this.checkIndex(n);
        double d = 0.0;
        if (!this._hashMap.containsKey(n)) {
            throw new JWaveFailureNotFound("Line - no value stored for requested i: " + n);
        }
        d = this._hashMap.get(n);
        return d;
    }

    @Override
    public void set(int n, double d) throws JWaveException {
        this.checkMemory();
        this.checkIndex(n);
        this._hashMap.put(n, d);
    }
}

