/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.spaces;

import jwave.datatypes.Super;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.blocks.BlockFull;
import jwave.datatypes.spaces.Space;
import jwave.exceptions.JWaveException;

public class SpaceFull
extends Space {
    protected Block[] _arrBlocks = null;

    public SpaceFull() {
    }

    public SpaceFull(Space space) {
        super(space);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    for (int k = 0; k < this._noOfLvls; ++k) {
                        this.set(i, j, k, space.get(i, j, k));
                    }
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
        }
    }

    public SpaceFull(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public SpaceFull(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    @Override
    public Space copy() {
        return new SpaceFull(this);
    }

    @Override
    public boolean isAllocated() {
        boolean bl = true;
        if (this._arrBlocks == null) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._arrBlocks = new Block[this._noOfLvls];
            for (int i = 0; i < this._noOfLvls; ++i) {
                BlockFull blockFull = new BlockFull(this._offSetRow, this._offSetCol, this._noOfRows, this._noOfCols);
                ((Super)blockFull).alloc();
                this._arrBlocks[i] = blockFull;
            }
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._arrBlocks != null) {
            for (int i = 0; i < this._noOfLvls; ++i) {
                if (this._arrBlocks[i] == null) continue;
                Block block = this._arrBlocks[i];
                block.erase();
                this._arrBlocks[i] = null;
            }
            this._arrBlocks = null;
        }
    }

    @Override
    public double get(int n, int n2, int n3) throws JWaveException {
        this.checkMemory();
        this.check(n, n2, n3);
        Block block = this._arrBlocks[n3];
        double d = block.get(n, n2);
        return d;
    }

    @Override
    public void set(int n, int n2, int n3, double d) throws JWaveException {
        this.checkMemory();
        this.check(n, n2, n3);
        Block block = this._arrBlocks[n3];
        block.set(n, n2, d);
    }
}

