/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.spaces;

import java.util.HashMap;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.blocks.BlockHash;
import jwave.datatypes.spaces.Space;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public class SpaceHash
extends Space {
    HashMap<Integer, Block> _hashMapBlocks = null;

    public SpaceHash() {
    }

    public SpaceHash(Space space) {
        super(space);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    for (int k = 0; k < this._noOfLvls; ++k) {
                        this.set(i, j, k, space.get(i, j, k));
                    }
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
        }
    }

    public SpaceHash(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public SpaceHash(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    @Override
    public Space copy() {
        return new SpaceHash(this);
    }

    @Override
    public boolean isAllocated() {
        boolean bl = true;
        if (this._hashMapBlocks == null) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._hashMapBlocks = new HashMap();
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._hashMapBlocks != null) {
            this._hashMapBlocks.clear();
        }
        this._hashMapBlocks = null;
    }

    @Override
    public double get(int n, int n2, int n3) throws JWaveException {
        this.checkMemory();
        this.check(n, n2, n3);
        Block block = null;
        double d = 0.0;
        if (!this._hashMapBlocks.containsKey(n3)) {
            throw new JWaveFailure("Line - no value stored for requested i: " + n);
        }
        block = this._hashMapBlocks.get(n3);
        d = block.get(n, n2);
        return d;
    }

    @Override
    public void set(int n, int n2, int n3, double d) throws JWaveException {
        this.checkMemory();
        this.check(n, n2, n3);
        Block block = null;
        if (this._hashMapBlocks.containsKey(n3)) {
            block = this._hashMapBlocks.get(n3);
            block.set(n, n2, d);
        } else {
            block = new BlockHash(this._offSetRow, this._offSetCol, this._noOfRows, this._noOfCols);
            block.alloc();
            block.set(n, n2, d);
            this._hashMapBlocks.put(n3, block);
        }
    }
}

