/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.spaces;

import jwave.datatypes.Super;
import jwave.datatypes.spaces.Space;
import jwave.datatypes.spaces.SpaceFull;
import jwave.datatypes.spaces.SpaceHash;
import jwave.exceptions.JWaveException;
import org.junit.Assert;
import org.junit.Test;

public class SpaceTest {
    private int _noOfRows = 100;
    private int _noOfCols = 100;
    private int _noOfLvls = 100;

    private Space genSpaceFullObject(int n, int n2, int n3) throws JWaveException {
        SpaceFull spaceFull = new SpaceFull(n, n2, n3);
        ((Super)spaceFull).alloc();
        for (int i = 0; i < spaceFull.getNoOfRows(); ++i) {
            for (int j = 0; j < spaceFull.getNoOfCols(); ++j) {
                for (int k = 0; k < spaceFull.getNoOfLvls(); ++k) {
                    ((Space)spaceFull).set(i, j, k, i + j + k);
                }
            }
        }
        return spaceFull;
    }

    private Space genSpaceHashObject(int n, int n2, int n3) throws JWaveException {
        SpaceHash spaceHash = new SpaceHash(n, n2, n3);
        ((Super)spaceHash).alloc();
        for (int i = 0; i < spaceHash.getNoOfRows(); ++i) {
            for (int j = 0; j < spaceHash.getNoOfCols(); ++j) {
                for (int k = 0; k < spaceHash.getNoOfLvls(); ++k) {
                    ((Space)spaceHash).set(i, j, k, i + j + k);
                }
            }
        }
        return spaceHash;
    }

    @Test
    public void testGet() {
        try {
            int n;
            int n2;
            int n3;
            Space space = this.genSpaceFullObject(this._noOfRows, this._noOfCols, this._noOfLvls);
            for (n3 = 0; n3 < space.getNoOfRows(); ++n3) {
                for (n2 = 0; n2 < space.getNoOfCols(); ++n2) {
                    for (n = 0; n < space.getNoOfLvls(); ++n) {
                        Assert.assertEquals((double)(n3 + n2 + n), (double)space.get(n3, n2, n), (double)0.0);
                    }
                }
            }
            space = this.genSpaceHashObject(this._noOfRows, this._noOfCols, this._noOfLvls);
            for (n3 = 0; n3 < space.getNoOfRows(); ++n3) {
                for (n2 = 0; n2 < space.getNoOfCols(); ++n2) {
                    for (n = 0; n < space.getNoOfLvls(); ++n) {
                        Assert.assertEquals((double)(n3 + n2 + n), (double)space.get(n3, n2, n), (double)0.0);
                    }
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
            Assert.fail((String)"caught exception");
        }
    }

    @Test
    public void testSet() {
        try {
            int n;
            int n2;
            int n3;
            Space space = this.genSpaceFullObject(this._noOfRows, this._noOfCols, this._noOfLvls);
            for (n3 = 0; n3 < space.getNoOfRows(); ++n3) {
                for (n2 = 0; n2 < space.getNoOfCols(); ++n2) {
                    for (n = 0; n < space.getNoOfLvls(); ++n) {
                        space.set(n3, n2, n, n3 + n2 + n + 1);
                    }
                }
            }
            for (n3 = 0; n3 < space.getNoOfRows(); ++n3) {
                for (n2 = 0; n2 < space.getNoOfCols(); ++n2) {
                    for (n = 0; n < space.getNoOfLvls(); ++n) {
                        Assert.assertEquals((double)(n3 + n2 + n + 1), (double)space.get(n3, n2, n), (double)0.0);
                    }
                }
            }
            space = this.genSpaceHashObject(this._noOfRows, this._noOfCols, this._noOfLvls);
            for (n3 = 0; n3 < space.getNoOfRows(); ++n3) {
                for (n2 = 0; n2 < space.getNoOfCols(); ++n2) {
                    for (n = 0; n < space.getNoOfLvls(); ++n) {
                        space.set(n3, n2, n, n3 + n2 + n + 1);
                    }
                }
            }
            for (n3 = 0; n3 < space.getNoOfRows(); ++n3) {
                for (n2 = 0; n2 < space.getNoOfCols(); ++n2) {
                    for (n = 0; n < space.getNoOfLvls(); ++n) {
                        Assert.assertEquals((double)(n3 + n2 + n + 1), (double)space.get(n3, n2, n), (double)0.0);
                    }
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
            Assert.fail((String)"caught exception");
        }
    }
}

