/*
 * Decompiled with CFR 0.152.
 */
package jwave.tools;

import jwave.exceptions.JWaveError;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public class MathToolKit {
    public static int[] decompose(int n) throws JWaveException {
        if (n < 1) {
            throw new JWaveFailure("the supported number for decomposition is smaller than one");
        }
        int n2 = MathToolKit.getExponent(n);
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        double d = n;
        while (d >= 1.0) {
            nArray[n3] = n2 = MathToolKit.getExponent(d);
            d -= MathToolKit.scalb(1.0, n2);
            ++n3;
        }
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public static int[] decompose(int n, int n2) throws JWaveException {
        int[] nArray = null;
        if (!MathToolKit.isBinary(n2)) {
            throw new JWaveFailure("given block size is not 2^p|p={1,2,3,4,..}. block size shold be e. g.: 4, 8, 16, 32, ..");
        }
        if (n < n2) {
            throw new JWaveFailure("Given blockSize is greater than the given number to be split by it");
        }
        int n3 = n % n2;
        int n4 = n - n3 * n2;
        int[] nArray2 = MathToolKit.decompose(n4);
        int n5 = nArray2.length + n3;
        nArray = new int[n5];
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            if (i < n3) {
                nArray[i] = n2;
                continue;
            }
            nArray[i] = nArray2[n6];
            ++n6;
        }
        return nArray;
    }

    public static int compose(int[] nArray) throws JWaveException {
        if (nArray == null) {
            throw new JWaveError("given array is null");
        }
        int n = 0;
        for (int n2 : nArray) {
            n += (int)MathToolKit.scalb(1.0, n2);
        }
        return n;
    }

    public static boolean isBinary(int n) {
        boolean bl = false;
        int n2 = (int)(Math.log(n) / Math.log(2.0));
        double d = 1.0 * Math.pow(2.0, n2);
        if (d == (double)n) {
            bl = true;
        }
        return bl;
    }

    public static int getExponent(double d) {
        int n = (int)(Math.log(d) / Math.log(2.0));
        return n;
    }

    public static double scalb(double d, int n) {
        double d2 = d * Math.pow(2.0, n);
        return d2;
    }

    public static double[] createSineOscillation(int n, int n2) {
        if (n < 1) {
            n = 2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = Math.PI * 2 * (double)i / (double)n * (double)n2;
            dArray[i] = d = Math.sin(d2);
        }
        return dArray;
    }

    public static double[] createCosineOscillation(int n, int n2) {
        if (n < 1) {
            n = 2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = Math.PI * 2 * (double)i / (double)n * (double)n2;
            dArray[i] = d = Math.cos(d2);
        }
        return dArray;
    }
}

