/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.datatypes.natives.Complex;
import jwave.exceptions.JWaveError;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.tools.MathToolKit;
import jwave.transforms.wavelets.Wavelet;

public abstract class BasicTransform {
    protected String _name = null;

    public String getName() {
        return this._name;
    }

    public Wavelet getWavelet() throws JWaveFailure {
        throw new JWaveFailure("BasicTransform#getWavelet - not available");
    }

    public abstract double[] forward(double[] var1) throws JWaveException;

    public abstract double[] reverse(double[] var1) throws JWaveException;

    public double[] forward(double[] dArray, int n) throws JWaveException {
        throw new JWaveError("BasicTransform#forward - method is not implemented for this transform type!");
    }

    public double[] reverse(double[] dArray, int n) throws JWaveException {
        throw new JWaveError("BasicTransform#reverse - method is not implemented for this transform type!");
    }

    public double[][] decompose(double[] dArray) throws JWaveException {
        throw new JWaveError("BasicTransform#decompose - method is not implemented for this transform type!");
    }

    public double[] recompose(double[][] dArray) throws JWaveException {
        int n = dArray.length - 1;
        double[] dArray2 = null;
        try {
            dArray2 = this.recompose(dArray, n);
        }
        catch (JWaveFailure jWaveFailure) {
            jWaveFailure.showMessage();
            jWaveFailure.printStackTrace();
        }
        return dArray2;
    }

    public double[] recompose(double[][] dArray, int n) throws JWaveException {
        double[] dArray2 = null;
        try {
            dArray2 = this.recompose(dArray, n);
        }
        catch (JWaveFailure jWaveFailure) {
            jWaveFailure.showMessage();
            jWaveFailure.printStackTrace();
        }
        return dArray2;
    }

    public Complex[] forward(Complex[] complexArray) throws JWaveException {
        double[] dArray = new double[2 * complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            int n = i * 2;
            dArray[n] = complexArray[i].getReal();
            dArray[n + 1] = complexArray[i].getImag();
        }
        double[] dArray2 = this.forward(dArray);
        Complex[] complexArray2 = new Complex[complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            int n = i * 2;
            complexArray2[i] = new Complex(dArray2[n], dArray2[n + 1]);
        }
        return complexArray2;
    }

    public Complex[] reverse(Complex[] complexArray) throws JWaveException {
        double[] dArray = new double[2 * complexArray.length];
        for (int i = 0; i < complexArray.length; ++i) {
            int n = i * 2;
            dArray[n] = complexArray[i].getReal();
            dArray[n + 1] = complexArray[i].getImag();
        }
        double[] dArray2 = this.reverse(dArray);
        Complex[] complexArray2 = new Complex[complexArray.length];
        for (int i = 0; i < complexArray2.length; ++i) {
            int n = i * 2;
            complexArray2[i] = new Complex(dArray2[n], dArray2[n + 1]);
        }
        return complexArray2;
    }

    public double[][] forward(double[][] dArray) throws JWaveException {
        int n = MathToolKit.getExponent(dArray.length);
        int n2 = MathToolKit.getExponent(dArray[0].length);
        return this.forward(dArray, n, n2);
    }

    public double[][] forward(double[][] dArray, int n, int n2) throws JWaveException {
        int n3;
        double[] dArray2;
        double[] dArray3;
        int n4;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        double[][] dArray4 = new double[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray3 = new double[n6];
            for (int i = 0; i < n6; ++i) {
                dArray3[i] = dArray[n4][i];
            }
            dArray2 = this.forward(dArray3, n2);
            for (n3 = 0; n3 < n6; ++n3) {
                dArray4[n4][n3] = dArray2[n3];
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            dArray3 = new double[n5];
            for (int i = 0; i < n5; ++i) {
                dArray3[i] = dArray4[i][n4];
            }
            dArray2 = this.forward(dArray3, n);
            for (n3 = 0; n3 < n5; ++n3) {
                dArray4[n3][n4] = dArray2[n3];
            }
        }
        return dArray4;
    }

    public double[][] reverse(double[][] dArray) throws JWaveException {
        int n = MathToolKit.getExponent(dArray.length);
        int n2 = MathToolKit.getExponent(dArray[0].length);
        return this.reverse(dArray, n, n2);
    }

    public double[][] reverse(double[][] dArray, int n, int n2) throws JWaveException {
        int n3;
        double[] dArray2;
        double[] dArray3;
        int n4;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        double[][] dArray4 = new double[n5][n6];
        for (n4 = 0; n4 < n6; ++n4) {
            dArray3 = new double[n5];
            for (int i = 0; i < n5; ++i) {
                dArray3[i] = dArray[i][n4];
            }
            dArray2 = this.reverse(dArray3, n);
            for (n3 = 0; n3 < n5; ++n3) {
                dArray4[n3][n4] = dArray2[n3];
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            dArray3 = new double[n6];
            for (int i = 0; i < n6; ++i) {
                dArray3[i] = dArray4[n4][i];
            }
            dArray2 = this.reverse(dArray3, n2);
            for (n3 = 0; n3 < n6; ++n3) {
                dArray4[n4][n3] = dArray2[n3];
            }
        }
        return dArray4;
    }

    public double[][][] forward(double[][][] dArray) throws JWaveException {
        int n = MathToolKit.getExponent(dArray.length);
        int n2 = MathToolKit.getExponent(dArray[0].length);
        int n3 = MathToolKit.getExponent(dArray[0][0].length);
        return this.forward(dArray, n, n2, n3);
    }

    public double[][][] forward(double[][][] dArray, int n, int n2, int n3) throws JWaveException {
        int n4;
        Object object;
        int n5;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        int n8 = dArray[0][0].length;
        double[][][] dArray2 = new double[n6][n7][n8];
        for (n5 = 0; n5 < n6; ++n5) {
            int n9;
            double[][] dArray3 = new double[n7][n8];
            for (int i = 0; i < n7; ++i) {
                for (n9 = 0; n9 < n8; ++n9) {
                    dArray3[i][n9] = dArray[n5][i][n9];
                }
            }
            object = this.forward(dArray3, n, n2);
            for (n9 = 0; n9 < n7; ++n9) {
                for (n4 = 0; n4 < n8; ++n4) {
                    dArray2[n5][n9][n4] = object[n9][n4];
                }
            }
        }
        for (n5 = 0; n5 < n7; ++n5) {
            for (int i = 0; i < n8; ++i) {
                object = new double[n6];
                for (int j = 0; j < n6; ++j) {
                    object[j] = dArray2[j][n5][i];
                }
                double[] dArray4 = this.forward((double[])object, n3);
                for (n4 = 0; n4 < n6; ++n4) {
                    dArray2[n4][n5][i] = dArray4[n4];
                }
            }
        }
        return dArray2;
    }

    public double[][][] reverse(double[][][] dArray) throws JWaveException {
        int n = MathToolKit.getExponent(dArray.length);
        int n2 = MathToolKit.getExponent(dArray[0].length);
        int n3 = MathToolKit.getExponent(dArray[0][0].length);
        return this.reverse(dArray, n, n2, n3);
    }

    public double[][][] reverse(double[][][] dArray, int n, int n2, int n3) throws JWaveException {
        int n4;
        Object object;
        int n5;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        int n8 = dArray[0][0].length;
        double[][][] dArray2 = new double[n6][n7][n8];
        for (n5 = 0; n5 < n6; ++n5) {
            int n9;
            double[][] dArray3 = new double[n7][n8];
            for (int i = 0; i < n7; ++i) {
                for (n9 = 0; n9 < n8; ++n9) {
                    dArray3[i][n9] = dArray[n5][i][n9];
                }
            }
            object = this.reverse(dArray3, n, n2);
            for (n9 = 0; n9 < n7; ++n9) {
                for (n4 = 0; n4 < n8; ++n4) {
                    dArray2[n5][n9][n4] = object[n9][n4];
                }
            }
        }
        for (n5 = 0; n5 < n7; ++n5) {
            for (int i = 0; i < n8; ++i) {
                object = new double[n6];
                for (int j = 0; j < n6; ++j) {
                    object[j] = dArray2[j][n5][i];
                }
                double[] dArray4 = this.reverse((double[])object, n3);
                for (n4 = 0; n4 < n6; ++n4) {
                    dArray2[n4][n5][i] = dArray4[n4];
                }
            }
        }
        return dArray2;
    }

    protected boolean isBinary(int n) {
        return MathToolKit.isBinary(n);
    }

    protected int calcExponent(int n) throws JWaveException {
        if (!this.isBinary(n)) {
            throw new JWaveFailure("BasicTransform#calcExponent - given number is not binary: 2^p | pEN .. = 1, 2, 4, 8, 16, 32, .. ");
        }
        return MathToolKit.getExponent(n);
    }
}

