/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.datatypes.natives.Complex;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;

public class DiscreteFourierTransform
extends BasicTransform {
    public DiscreteFourierTransform() {
        this._name = "Discrete Fourier Transform";
    }

    @Override
    public double[] forward(double[] dArray) throws JWaveException {
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("DiscreteFourierTransform#forward - given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = n >> 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = i * 2;
            int n4 = i * 2 + 1;
            dArray2[n3] = 0.0;
            dArray2[n4] = 0.0;
            double d = Math.PI * -2 * (double)i / (double)n2;
            for (int j = 0; j < n2; ++j) {
                int n5 = j * 2;
                int n6 = j * 2 + 1;
                double d2 = Math.cos((double)j * d);
                double d3 = Math.sin((double)j * d);
                int n7 = n3;
                dArray2[n7] = dArray2[n7] + (dArray[n5] * d2 - dArray[n6] * d3);
                int n8 = n4;
                dArray2[n8] = dArray2[n8] + (dArray[n5] * d3 + dArray[n6] * d2);
            }
            int n9 = n3;
            dArray2[n9] = dArray2[n9] / (double)n2;
            int n10 = n4;
            dArray2[n10] = dArray2[n10] / (double)n2;
        }
        return dArray2;
    }

    @Override
    public double[] reverse(double[] dArray) throws JWaveException {
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("DiscreteFourierTransform#reverse - given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = n >> 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = i * 2;
            int n4 = i * 2 + 1;
            dArray2[n3] = 0.0;
            dArray2[n4] = 0.0;
            double d = Math.PI * 2 * (double)i / (double)n2;
            for (int j = 0; j < n2; ++j) {
                int n5 = j * 2;
                int n6 = j * 2 + 1;
                double d2 = Math.cos((double)j * d);
                double d3 = Math.sin((double)j * d);
                int n7 = n3;
                dArray2[n7] = dArray2[n7] + (dArray[n5] * d2 - dArray[n6] * d3);
                int n8 = n4;
                dArray2[n8] = dArray2[n8] + (dArray[n5] * d3 + dArray[n6] * d2);
            }
        }
        return dArray2;
    }

    @Override
    public double[] forward(double[] dArray, int n) throws JWaveException {
        return this.forward(dArray);
    }

    @Override
    public double[] reverse(double[] dArray, int n) throws JWaveException {
        return this.reverse(dArray);
    }

    @Override
    public Complex[] forward(Complex[] complexArray) {
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray2[i] = new Complex();
            double d = Math.PI * -2 * (double)i / (double)n;
            for (int j = 0; j < n; ++j) {
                double d2 = Math.cos((double)j * d);
                double d3 = Math.sin((double)j * d);
                double d4 = complexArray[j].getReal();
                double d5 = complexArray[j].getImag();
                complexArray2[i].addReal(d4 * d2 - d5 * d3);
                complexArray2[i].addImag(d4 * d3 + d5 * d2);
            }
            complexArray2[i].mulReal(1.0 / (double)n);
            complexArray2[i].mulImag(1.0 / (double)n);
        }
        return complexArray2;
    }

    @Override
    public Complex[] reverse(Complex[] complexArray) {
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray2[i] = new Complex();
            double d = Math.PI * 2 * (double)i / (double)n;
            for (int j = 0; j < n; ++j) {
                double d2 = Math.cos((double)j * d);
                double d3 = Math.sin((double)j * d);
                double d4 = complexArray[j].getReal();
                double d5 = complexArray[j].getImag();
                complexArray2[i].addReal(d4 * d2 - d5 * d3);
                complexArray2[i].addImag(d4 * d3 + d5 * d2);
            }
        }
        return complexArray2;
    }
}

