/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import java.util.Arrays;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.WaveletTransform;
import jwave.transforms.wavelets.Wavelet;

public class FastWaveletTransform
extends WaveletTransform {
    public FastWaveletTransform(Wavelet wavelet) {
        super(wavelet);
        this._name = "Fast Wavelet Transform";
    }

    @Override
    public double[] forward(double[] dArray, int n) throws JWaveException {
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("FastWaveletTransform#forward - given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n2 = this.calcExponent(dArray.length);
        if (n < 0 || n > n2) {
            throw new JWaveFailure("FastWaveletTransform#forward - given level is out of range for given array");
        }
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        int n3 = 0;
        int n4 = this._wavelet.getTransformWavelength();
        for (int i = dArray2.length; i >= n4 && n3 < n; i >>= 1, ++n3) {
            double[] dArray3 = this._wavelet.forward(dArray2, i);
            System.arraycopy(dArray3, 0, dArray2, 0, i);
        }
        return dArray2;
    }

    @Override
    public double[] reverse(double[] dArray, int n) throws JWaveException {
        int n2;
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("FastWaveletTransform#reverse - given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n3 = this.calcExponent(dArray.length);
        if (n < 0 || n > n3) {
            throw new JWaveFailure("FastWaveletTransform#reverse - given level is out of range for given array");
        }
        int n4 = dArray.length;
        double[] dArray2 = Arrays.copyOf(dArray, n4);
        int n5 = n2 = this._wavelet.getTransformWavelength();
        int n6 = this.calcExponent(n4);
        for (int i = n; i < n6; ++i) {
            n5 <<= 1;
        }
        while (n5 <= dArray2.length && n5 >= n2) {
            double[] dArray3 = this._wavelet.reverse(dArray2, n5);
            System.arraycopy(dArray3, 0, dArray2, 0, n5);
            n5 <<= 1;
        }
        return dArray2;
    }
}

