/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import java.util.Arrays;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.WaveletTransform;
import jwave.transforms.wavelets.Wavelet;

public class WaveletPacketTransform
extends WaveletTransform {
    public WaveletPacketTransform(Wavelet wavelet) {
        super(wavelet);
        this._name = "Wavelet Packet Transform";
    }

    @Override
    public double[] forward(double[] dArray, int n) throws JWaveException {
        int n2;
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n3 = this.calcExponent(dArray.length);
        if (n < 0 || n > n3) {
            throw new JWaveFailure("WaveletPacketTransform#forward - given level is out of range for given array");
        }
        double[] dArray2 = new double[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        n2 = dArray.length;
        int n4 = dArray.length;
        int n5 = this._wavelet.getTransformWavelength();
        for (int i = 0; n4 >= n5 && i < n; n4 >>= 1, ++i) {
            int n6 = n2 / n4;
            for (int j = 0; j < n6; ++j) {
                double[] dArray3 = new double[n4];
                for (int k = 0; k < n4; ++k) {
                    dArray3[k] = dArray2[k + j * n4];
                }
                double[] dArray4 = this._wavelet.forward(dArray3, n4);
                for (int k = 0; k < n4; ++k) {
                    dArray2[k + j * n4] = dArray4[k];
                }
            }
        }
        return dArray2;
    }

    @Override
    public double[] reverse(double[] dArray, int n) throws JWaveException {
        int n2;
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n3 = this.calcExponent(dArray.length);
        if (n < 0 || n > n3) {
            throw new JWaveFailure("WaveletPacketTransform#reverse - given level is out of range for given array");
        }
        int n4 = dArray.length;
        double[] dArray2 = Arrays.copyOf(dArray, n4);
        int n5 = this._wavelet.getTransformWavelength();
        int n6 = dArray2.length;
        int n7 = n5;
        int n8 = this.calcExponent(n4);
        for (n2 = n; n2 < n8; ++n2) {
            n7 <<= 1;
        }
        while (n7 <= dArray2.length && n7 >= n5) {
            n2 = n6 / n7;
            for (int i = 0; i < n2; ++i) {
                double[] dArray3 = new double[n7];
                for (int j = 0; j < n7; ++j) {
                    dArray3[j] = dArray2[j + i * n7];
                }
                double[] dArray4 = this._wavelet.reverse(dArray3, n7);
                for (int j = 0; j < n7; ++j) {
                    dArray2[j + i * n7] = dArray4[j];
                }
            }
            n7 <<= 1;
        }
        return dArray2;
    }
}

