/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.haar;

import jwave.transforms.wavelets.Wavelet;

public class Haar1Orthogonal
extends Wavelet {
    public Haar1Orthogonal() {
        this._name = "Haar orthogonal";
        this._transformWavelength = 2;
        this._motherWavelength = 2;
        this._scalingDeCom = new double[this._motherWavelength];
        this._scalingDeCom[0] = 1.0;
        this._scalingDeCom[1] = 1.0;
        this._waveletDeCom = new double[this._motherWavelength];
        this._waveletDeCom[0] = this._scalingDeCom[1];
        this._waveletDeCom[1] = -this._scalingDeCom[0];
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (int i = 0; i < this._motherWavelength; ++i) {
            this._scalingReCon[i] = this._scalingDeCom[i];
            this._waveletReCon[i] = this._waveletDeCom[i];
        }
    }

    @Override
    public double[] reverse(double[] dArray, int n) {
        int n2;
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = 0.0;
        }
        n2 = dArray2.length >> 1;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int n3;
                for (n3 = i * 2 + j; n3 >= dArray2.length; n3 -= dArray2.length) {
                }
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + 0.5 * (dArray[i] * this._scalingReCon[j] + dArray[i + n2] * this._waveletReCon[j]);
            }
        }
        return dArray2;
    }
}

